
%% *************************************************************************************************************************************
%% * ******************************************** ************************************************************************************ *
%% * *              LATEX TEMPLATE              * *                     File       : Ph.D. Thesis CLASS File                         * *
%% * *                   FOR                    * *                     Created By : Satvir Singh Sidhu                              * *
%% * *               PH.D. THESIS               * *                     Email      : satvir15@gmail.com                              * *
%% * ******************************************** **************************************************************************************
%% *************************************************************************************************************************************

%% =====================================================================================================================================
%%                                                  PH.D. THESIS DOCUMENT CLASS FILE
%% =====================================================================================================================================
\NeedsTeXFormat{LaTeX2e}[1996/12/01]
\ProvidesClass{Thesis}
              [2007/22/02 v1.0 LaTeX document class]
\def\baseclass{book}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{\baseclass}}
\def\@checkoptions#1#2{
  \edef\@curroptions{\@ptionlist{\@currname.\@currext}}
  \@tempswafalse
  \@tfor\@this:=#2\do{
    \@expandtwoargs\in@{,\@this,}{,\@curroptions,}
    \ifin@ \@tempswatrue \@break@tfor \fi}
  \let\@this\@empty
  \if@tempswa \else \PassOptionsToClass{#1}{\baseclass}\fi}
\@checkoptions{11pt}{{10pt}{11pt}{12pt}}
\PassOptionsToClass{a4paper}{\baseclass}
\ProcessOptions\relax
\LoadClass{\baseclass}
\newcommand\bhrule{\typeout{------------------------------------------------------------------------------}}

\newcommand\btypeout[1]{\bhrule\typeout{\space #1}\bhrule}
\def\monthyear{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space \number\year}
\usepackage{setspace}
\onehalfspacing
\setlength{\parindent}{0pt}
\setlength{\parskip}{2.0ex plus0.5ex minus0.2ex}
\usepackage{vmargin}
\setmarginsrb           { 1.5in}  % left margin
                        { 0.8in}  % top margin
                        { 1.0in}  % right margin
                        { 0.8in}  % bottom margin
                        {  10pt}  % head height
                        {0.25in}  % head sep
                        {   9pt}  % foot height
                        { 0.3in}  % foot sep
\raggedbottom
\setlength{\topskip}{1\topskip \@plus 5\p@}
\doublehyphendemerits=10000       % No consecutive line hyphens.
\brokenpenalty=10000              % No broken words across columns/pages.
\widowpenalty=9999                % Almost no widows at bottom of page.
\clubpenalty=9999                 % Almost no orphans at top of page.
\interfootnotelinepenalty=9999    % Almost never break footnotes.
\usepackage{fancyhdr}
\lhead[\rm\thepage]{\fancyplain{}{\sl{\rightmark}}}
\rhead[\fancyplain{}{\sl{\leftmark}}]{\rm\thepage}
\chead{}\lfoot{}\rfoot{}\cfoot{}
\pagestyle{fancy}
\renewcommand{\chaptermark}[1]{\btypeout{\thechapter\space #1}\markboth{\@chapapp\ \thechapter\ #1}{\@chapapp\ \thechapter\ #1}}
\renewcommand{\sectionmark}[1]{\markright{\thesection\ #1}}
\renewcommand{\subsectionmark}[1]{}
\def\cleardoublepage{\clearpage\if@twoside \ifodd\c@page\else
\hbox{}
\thispagestyle{empty}
\newpage
\if@twocolumn\hbox{}\newpage\fi\fi\fi}
\usepackage{amsmath,amsfonts,amssymb,amscd,amsthm,xspace}
\theoremstyle{plain}
\newtheorem{example}{Example}[chapter]
\newtheorem{theorem}{Theorem}[chapter]
\newtheorem{corollary}[theorem]{Corollary}
\newtheorem{lemma}[theorem]{Lemma}
\newtheorem{proposition}[theorem]{Proposition}
\newtheorem{axiom}[theorem]{Axiom}
\theoremstyle{definition}
\newtheorem{definition}[theorem]{Definition}
\theoremstyle{remark}
\newtheorem{remark}[theorem]{Remark}
\usepackage[centerlast,small,sc]{caption}
\setlength{\captionmargin}{20pt}
\newcommand{\fref}[1]{Figure~\ref{#1}}
\newcommand{\tref}[1]{Table~\ref{#1}}
\newcommand{\eref}[1]{Equation~\ref{#1}}
\newcommand{\cref}[1]{Chapter~\ref{#1}}
\newcommand{\sref}[1]{Section~\ref{#1}}
\newcommand{\aref}[1]{Appendix~\ref{#1}}
\renewcommand{\topfraction}{0.85}
\renewcommand{\bottomfraction}{.85}
\renewcommand{\textfraction}{0.1}
\renewcommand{\dbltopfraction}{.85}
\renewcommand{\floatpagefraction}{0.75}
\renewcommand{\dblfloatpagefraction}{.75}
\setcounter{topnumber}{9}
\setcounter{bottomnumber}{9}
\setcounter{totalnumber}{20}
\setcounter{dbltopnumber}{9}
\usepackage{graphicx}
\usepackage{epstopdf}
\usepackage[scriptsize]{subfigure}
\usepackage[Conny]{fncychapleo}
\usepackage{booktabs}
\usepackage{rotating}
\usepackage{listings}
\usepackage{lstpatch}
\lstset{captionpos=b,
        frame=tb,
        basicstyle=\scriptsize\ttfamily,
        showstringspaces=false,
        keepspaces=true}
\lstdefinestyle{matlab} {
        language=Matlab,
        keywordstyle=\color{blue},
        commentstyle=\color[rgb]{0.13,0.55,0.13}\em,
        stringstyle=\color[rgb]{0.7,0,0} }
\usepackage[pdfpagemode={UseOutlines},bookmarks=true,bookmarksopen=true,
   bookmarksopenlevel=0,bookmarksnumbered=true,hypertexnames=false,
   colorlinks,linkcolor={black},citecolor={blue},urlcolor={red},
   pdfstartview={FitH},unicode,breaklinks=true]{hyperref}
\pdfstringdefDisableCommands{
   \let\\\space}

%========================DON'T CHANGE THIS TEXT==================================
\newcommand*{\Mainsupervisor}[1]{\def\msupname{#1}}
\newcommand*{\Cosupervisor}[1]{\def\csupname{#1}}
\newcommand*{\Registration}[1]{\def\regn{#1}}
\newcommand*{\university}[1]{\def\univname{#1}}
\newcommand*{\UNIVERSITY}[1]{\def\UNIVNAME{#1}}
\newcommand*{\department}[1]{\def\deptname{#1}}
\newcommand*{\DEPARTMENT}[1]{\def\DEPTNAME{#1}}
\newcommand*{\faculty}[1]{\def\facname{#1}}
\newcommand*{\FACULTY}[1]{\def\FACNAME{#1}}

\newcommand*{\addresses}[1]{\def\addressnames{#1}}
\newcommand*{\authoremail}[1]{\def\authorlink{#1}}
\newcommand*{\student}[1]{\def\authorname{#1}}
\newcommand*{\topic}[1]{\def\thesistopic{#1}}
\newcommand*{\degree}[1]{\def\degreename{#1}}
\newcommand*{\examiner}[1]{\def\examname{#1}}
\newcommand*{\keywords}[1]{\def\keywordnames{#1}}
\newcommand*{\subject}[1]{\def\subjectname{#1}}

\addresses      {}
\authoremail    {}
\student        {}
\topic          {}
\examiner       {}
\degree         {}
\keywords       {}
\subject        {}

%================================================================================
%========================PERSONALIZE THIS TEXT===================================
%================================================================================
\Mainsupervisor {Professor Satvir Singh}
\Cosupervisor   {Professor Arun Khosla}
\university     {IKG Punjab Technical University, Kapurthala}
\department     {Computer Science \& Engineering}
\DEPARTMENT     {COMPUTER SCIENCE \& ENGINEERING}
\faculty        {Faculty of Engineering \& Technology}
\FACULTY        {FACULTY OF ENGINEERING \& TECHNOLOGY}
\Registration   {Registration No.: 2005/Engg. \& Tech./07 Dated: 14.06.2005}
\UNIVERSITY     {\texorpdfstring{\href{http://www.ptu.ac.in}
                {IKG PUNJAB TECHNICAL UNIVERSITY\\KAPURTHALA-144603 (PB) INDIA}}
                {IKG PUNJAB TECHNICAL UNIVERSITY\\KAPURTHALA-144603 (PB) INDIA}}
%================================================================================
%========================PERSONALIZE THIS TEXT===================================
%================================================================================


%========================TITLE PAGE 1===========================================
\renewcommand\maketitle{
  \btypeout{Title Page}
  \hypersetup{pdftitle={\@title}}
  \hypersetup{pdfsubject=\subjectname}
  \hypersetup{pdfauthor=\authorlink}
  \hypersetup{pdfkeywords=\keywordnames}
  \thispagestyle{empty}
  \begin{titlepage}
    \let\footnotesize\small
    \let\footnoterule\relax
    \let \footnote \thanks
    \setcounter{footnote}{0}
    \begin{center}
      \setlength{\parskip}{0pt}
      {\LARGE \bf \@title \par}
      \vskip 20\p@
      {\Large \textbf{A} \par}
      {\Large \textbf{\sc{Ph.D. Thesis}} \par}
      {\Large \textbf{\sc{submitted}} \par}
      \vskip 2\p@
      \begin{figure}[!h]
      \centering
      \includegraphics[width=2in]{./FrontMatter/newPTULogo}
      \end{figure}
      \vskip 5mm
      {\large \textbf{IN FULFILLMENT OF THE REQUIREMENTS\\FOR THE DEGREE OF} \par}
      \vskip 5mm
      {\Large \textbf{DOCTOR OF PHILOSOPHY} \par}
      \vskip 5mm
    {\large \textbf{By} \par}
    \vskip 4mm
    {\Large\textbf{\authorlink} \par}
    {\large\textbf{(Registration No. 1203043)} \par}
    \vskip 7mm
    {\Large \textbf{\DEPTNAME} \par}
    \vskip 3mm
    {\Large \textbf{\UNIVNAME} \par}
    \vskip 3mm
    {\large \textbf{2016} \par}
    \date{}
    \end{center}
      \end{titlepage}
      \clearpage
    \par
    \@thanks
  \clearpage



 }
%========================TITLE PAGE 2===========================================
 %\thispagestyle{empty}
  %  \vskip 20\p@
   %%  \setlength{\parskip}{0pt}
     % {\LARGE \bf \@title \par}
     % \vskip 20\p@
      %{\LARGE \sc \textbf{\authorlink} \par}
     % \vskip 10\p@
     % {\LARGE Under the Guidance of \par}
 %     {
 %     \begin{table}[h]
  %    \centering
  %        \includegraphics[width=\textwidth]{./FrontMatter/Supervisors.pdf}
  %    \end{table}
  %    }
   %   \begin{figure}[!h]
   %   \centering
    %     \includegraphics[width=2in]{./FrontMatter/NITLogo}
    %  \end{figure}
  %    {\large \textit{Deserttration submitted in the partial fulfillment for the degree of}\par}
   %   {\LARGE \emph{Doctor of Philosophy} \par}
    %  \vskip 20\p@
    %  {\large {DEPARTMENT OF {\FACNAME} \par}}
    %  {\large\textbf{\UNIVNAME}\par}
     %\bigskip
   %   {\Large \@date \par}
%      \bigskip
  %  \end{center}
 %   \par
 %   \@thanks

  %\clearpage

%=========================ABSTRACT==============================================
\newenvironment{abstract}
{ \btypeout{Abstract Page}
  \thispagestyle{empty}
  \begin{center}
    \setlength{\parskip}{0pt}
    {\huge{\textit{Abstract}} \par}
    \bigskip
  \end{center}}
{ \vfil\vfil\null
  \clearpage}
%=========================CONTENTS==============================================
\addtocounter{secnumdepth}{1}
\setcounter{tocdepth}{6}
\newcounter{dummy}
\newcommand\addtotoc[1]{
\refstepcounter{dummy}
\addcontentsline{toc}{chapter}{#1}}
\renewcommand\tableofcontents{
\btypeout{Table of Contents}
\begin{spacing}{1.1}{
    \setlength{\parskip}{1pt}
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\contentsname
        \@mkboth{
           \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}
    \@starttoc{toc}
    \if@restonecol\twocolumn\fi
   \clearpage}
\end{spacing}}
%=========================FIGURE LIST===========================================
\renewcommand\listoffigures{
\btypeout{List of Figures}
\addtotoc{List of Figures}
\begin{spacing}{1.3}{
    \setlength{\parskip}{1pt}
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\listfigurename
      \@mkboth{\MakeUppercase\listfigurename}
              {\MakeUppercase\listfigurename}}
    \@starttoc{lof}
    \if@restonecol\twocolumn\fi
    \clearpage}
\end{spacing}}
%=========================TABLE LIST===========================================
\renewcommand\listoftables{
\btypeout{List of Tables}
\addtotoc{List of Tables}
\begin{spacing}{1.3}{
    \setlength{\parskip}{1pt}
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\listtablename
      \@mkboth{
          \MakeUppercase\listtablename}{\MakeUppercase\listtablename}}
    \@starttoc{lot}
    \if@restonecol\twocolumn\fi
    \clearpage}
\end{spacing}}
%=========================ABBREVIATION=========================================
\newcommand\ListAbbreviations{Abbreviations}
\usepackage{longtable}
\newcommand\listofabbreviations[2]{
\btypeout{\ListAbbreviations}
\addtotoc{\ListAbbreviations}
\begin{spacing}{1}{
    \setlength{\parskip}{1pt}
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\ListAbbreviations
      \@mkboth{
          \MakeUppercase\ListAbbreviations}{\MakeUppercase\ListAbbreviations}}
    \begin{longtable}[l]{#1}#2\end{longtable}\par
    \clearpage}
\end{spacing}}
%=========================NOTATIONS===========================================
\newcommand\ListNotations{Notations}
\usepackage{longtable}
\newcommand\listofnotations[2]{
\btypeout{\ListNotations}
\addtotoc{\ListNotations}
\begin{spacing}{1}{
    \setlength{\parskip}{1pt}
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\ListNotations
      \@mkboth{
          \MakeUppercase\ListNotations}{\MakeUppercase\ListNotations}}
\begin{longtable}[l]{#1}#2\end{longtable}\par
    \clearpage}
\end{spacing}}
%=========================CONSTANTS=============================================
\newcommand\listconstants{Physical Constants}
\usepackage{longtable}
\newcommand\listofconstants[2]{
\btypeout{\listconstants}
\addtotoc{\listconstants}
    \chapter*{\listconstants
      \@mkboth{
          \MakeUppercase\listconstants}{\MakeUppercase\listconstants}}
\begin{longtable}[c]{#1}#2\end{longtable}\par
    \clearpage}
%=========================SYMBOLS===============================================
\newcommand\listnomenclature{Symbols}
\usepackage{longtable}
\newcommand\listofnomenclature[2]{
\btypeout{\listnomenclature}
\addtotoc{\listnomenclature}
    \chapter*{\listnomenclature
      \@mkboth{
          \MakeUppercase\listnomenclature}{\MakeUppercase\listnomenclature}}
\begin{longtable}[c]{#1}#2\end{longtable}\par
    \clearpage}
%=========================ACKNOWLEDGEMETS=======================================
\newcommand\acknowledgements[1]{
\btypeout{Acknowledgements}
\addtotoc{Acknowledgements}
    \chapter*{\acknowledgements
      \@mkboth{
          \MakeUppercase\acknowledgements}{\MakeUppercase\acknowledgements}}
%\thispagestyle{plain}
\begin{center}{\huge{\textit{Acknowledgements}} \par}\end{center}
{\normalsize #1}
\vfil\vfil\null}
%=========================CERTIFICATE===========================================
\newcommand\certificate[1]{
\btypeout{Certificate}
\addtotoc{Certificate}
\thispagestyle{plain}
\begin{center}{\huge{\textit{Certificate}} \par}\end{center}
{\normalsize #1}
  \vfil\vfil\vfil\null
  \clearpage}
%=========================DECLARATION===========================================
\newcommand\Declaration[1]{
\btypeout{Declaration}
\addtotoc{Declaration}
\thispagestyle{plain}
\begin{center}{\huge{\textit{Declaration}} \par}\end{center}
{\normalsize #1}
 \vfil\vfil\null
  \clearpage}
%=========================PUBLICATIONS==========================================
\newcommand\Publications[1]{
\btypeout{List of Thesis Outcomes}
\addtotoc{List of Thesis Outcomes}
\thispagestyle{plain}
\begin{center}{\huge{\textit{List of Thesis Outcomes}} \par}\end{center}
{\normalsize #1}
\vfil\vfil\null}
%=========================RESUME================================================
\newcommand\Resume[1]{
\btypeout{Resume}
\addtotoc{Biography}
\thispagestyle{plain}
\begin{center}{\huge{\textit{Biography}} \par}\end{center}
{\normalsize #1}
\vfil\vfil\null}
%=========================QUOTE=================================================
\newcommand\Quote[1]{
\btypeout{Quote}
\thispagestyle{plain}
\null\vfil
\vskip 60\p@
\begin{center}{\Large \sl #1}\end{center}
\begin{flushright}{\Large \sl \ldots Steve Jobs}\end{flushright}
\vfil\null
\clearpage}
%=========================DEDICATION============================================
\newcommand\Dedication[1]{
\btypeout{Dedication}
\thispagestyle{plain}
\null\vfil
\vskip 60\p@
\begin{center}{\Large \sl #1}\end{center}
\vfil\null
\clearpage}
%=========================COPYRIGHT=============================================
\newcommand\Copyright[1]{
\btypeout{Copyright}
\thispagestyle{plain}
\null\vfil
%\vfil\vfil\vfil\vfil\vfil\vfil\vfil\vfil\vfil
\vskip 60\p@
%\begin{center}{\Large \sl #1}\end{center}
{\normalsize #1}
\vfil\null
\cleardoublepage}
%=========================BACKMATTER=============================================
\renewcommand\backmatter{
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \addtotoc{\bibname}
  \btypeout{\bibname}
  \@mainmatterfalse}
\endinput
%=========================END - THESIS.CLS=======================================
